## Define Default Member

Allows for defining a hierarchy default member




### Description

The default member of a hierarchy can be redefined as following:

<pre>
DEFINE_DEFAULT_MEMBER mdx-member-name
</pre>

When evaluating a tuple, icCube is going to use the default member of all the dimensions being not defined in the tuple (either explicitly or via a filter/slicer). Most of the time that default member is the all member from the all level meaning that dimension is not taken into account (i.e., no filtering).

That is why we strongly advise always define (default behavior) a `All Level` in every hierarchy unless you understand the consequences. Note there might be scenario where this All Level makes no sense (e.g., with time dimension and/or partitioning dimension). But then keep in mind, you might encounter (at first) weird result as the default member(s) of the dimension(s) (not defined in the query/tuple) will be used and then will filter the result. Usually, in these scenario the reports/dashboards queries will always define such filters (e.g., a year).



### Since Version

4.8.2


                                                                      

### See Also


[DefaultMember](DefaultMember.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
